/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.provider.jffi;

import com.kenai.jaffl.LibraryOption;
import com.kenai.jaffl.provider.Invoker;
import com.kenai.jaffl.provider.jffi.DefaultInvokerFactory;
import com.kenai.jaffl.provider.jffi.SymbolNotFoundError;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Library
extends com.kenai.jaffl.provider.Library {
    private final String[] libraryNames;
    private volatile List<com.kenai.jffi.Library> nativeLibraries = Collections.EMPTY_LIST;

    Library(String string) {
        this.libraryNames = new String[]{string};
    }

    Library(String ... stringArray) {
        this.libraryNames = (String[])stringArray.clone();
    }

    @Override
    public Invoker getInvoker(Method method, Map<LibraryOption, ?> map) {
        return DefaultInvokerFactory.getInstance().createInvoker(method, this, map);
    }

    @Override
    public Object libraryLock() {
        return this;
    }

    long getSymbolAddress(String string) {
        for (com.kenai.jffi.Library library : this.getNativeLibraries()) {
            long l = library.getSymbolAddress(string);
            if (l == 0L) continue;
            return l;
        }
        return 0L;
    }

    long findSymbolAddress(String string) {
        long l = this.getSymbolAddress(string);
        if (l == 0L) {
            throw new SymbolNotFoundError(com.kenai.jffi.Library.getLastError());
        }
        return l;
    }

    private synchronized List<com.kenai.jffi.Library> getNativeLibraries() {
        if (!this.nativeLibraries.isEmpty()) {
            return this.nativeLibraries;
        }
        this.nativeLibraries = this.loadNativeLibraries();
        return this.nativeLibraries;
    }

    private synchronized List<com.kenai.jffi.Library> loadNativeLibraries() {
        ArrayList<com.kenai.jffi.Library> arrayList = new ArrayList<com.kenai.jffi.Library>();
        ArrayList arrayList2 = new ArrayList(0);
        for (String string : this.libraryNames) {
            String string2;
            com.kenai.jffi.Library library = com.kenai.jffi.Library.getCachedInstance(string, 1);
            if (library == null && string != null && (string2 = Library.locateLibrary(string)) != null && !string.equals(string2)) {
                library = com.kenai.jffi.Library.getCachedInstance(string2, 1);
            }
            if (library == null) {
                throw new UnsatisfiedLinkError(com.kenai.jffi.Library.getLastError());
            }
            arrayList.add(library);
        }
        return Collections.unmodifiableList(arrayList);
    }
}

